#!/usr/bin/perl
#
# Copyright 2002, Garrett A. Wollman
# All rights reserved.
#
# Redistribution and use in source and formatted forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in formatted form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: rexml.pl,v 1.5 2006/01/17 04:57:31 wollman Exp $
#

#
# A simple Perl script that uses XML::Writer to turn a newline-separated
# list of items into a simple XML document which expresses that list.
# We uniquify the list as we go.  (We don't want to use `sort -u' beforehand
# because we may want the results to be output in original document order.)
#

use Digest::MD5;		# Collisions not a big deal.
use XML::Writer;

%unique = ();

$w = new XML::Writer(DATA_MODE => 1, DATA_INDENT => 2)
    or die "new XML::Writer: $!\n";

$w->xmlDecl('utf-8', 'yes');
$w->comment("Automatically generated; do not edit.");
$w->startTag('list');
while (<>) {
    chomp;
    next if exists($unique{$_});
    $unique{$_} = 1;
    $w->dataElement('item', $_, 'id' => gensym($_));
}
$w->endTag('list');
$w->end();

exit 0;

sub gensym {
    return 'id_' . substr(Digest::MD5::md5_hex(@_[0]), 24);
}
