<?xml version='1.0'?>
<!--
   Copyright 2002, Garrett A. Wollman
   All rights reserved.
  
   Redistribution and use in source and formatted forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in formatted form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
  
   THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: pg-index.xsl,v 1.3 2003/03/31 04:53:42 wollman Exp $

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version='1.0'>
  <xsl:param name='indexname' select='index.xml'/>
  <xsl:param name='prefix'/>
  <xsl:output method='html' version='4.01' encoding='iso-8859-1' indent='yes'/>

  <xsl:template match="/">
    <html>
	<head>
	    <title>
		<xsl:if test="string-length($prefix)">
		  <xsl:value-of select="$prefix"/>
		  <xsl:text>: </xsl:text>
		</xsl:if>
		<xsl:text>Index of photo galleries</xsl:text>
	    </title>
	</head>
	<body>
	    <h1>Index of photo galleries</h1>
    	    <ul>
		<xsl:apply-templates select="/list/item"/>
	    </ul>
	</body>
    </html>
  </xsl:template>

  <xsl:template match='item'>
    <xsl:variable name="index" select="text()"/>
    <xsl:variable name="doc" select="document($index)"/>
    <li>
      <xsl:element name='a'>
	<xsl:attribute name='href'>
	  <xsl:value-of select='substring-before($index, $indexname)'/>
	</xsl:attribute>
	<xsl:if test="$doc/photos/title/@series">
	  <xsl:value-of select="$doc/photos/title/@series"/>
	  <xsl:text>: </xsl:text>
	</xsl:if>
	<xsl:value-of select="$doc/photos/title/text()"/>
      </xsl:element>
    </li>
  </xsl:template>
</xsl:stylesheet>
