--- Writer.pm.orig	Thu Mar 20 20:24:48 2003
+++ Writer.pm	Thu Mar 20 20:28:37 2003
@@ -177,13 +177,16 @@
   };
 
   my $doctype = sub {
-    my ($name, $publicId, $systemId) = (@_);
+    my ($name, $publicId, $systemId, $internalSubset) = (@_);
     $output->print("<!DOCTYPE $name");
     if ($publicId) {
       $output->print(" PUBLIC \"$publicId\" \"$systemId\"");
     } elsif ($systemId) {
       $output->print(" SYSTEM \"$systemId\"");
     }
+    if ($internalSubset) {
+      $output->print(" [\n", $internalSubset, "]");
+    }
     $output->print(">\n");
   };
 
@@ -323,7 +326,24 @@
     }
   };
 
-  
+  my $cdata = sub {
+    my $data = $_[0];
+    $output->print("<![CDATA[", $data, "]]>");
+    $hasData = 1;
+  };
+
+  my $SAFE_cdata = sub {
+    if ($elementLevel < 1) {
+      croak("Attempt to insert character data outside of document element");
+    } elsif ($dataMode && $hasElement) {
+      croak("Mixed content not allowed in data mode: character data");
+    } elsif ($_[0] =~ m/\]\]\>/) {
+      croak("Character data contains magic end sequence");
+    } else {
+      &{$cdata};
+    }
+  };
+
 				# Assign the correct closures based on
 				# the UNSAFE parameter
   if ($unsafe) {
@@ -335,6 +355,7 @@
 	     'STARTTAG' => $startTag,
 	     'EMPTYTAG' => $emptyTag,
 	     'ENDTAG' => $endTag,
+	     'CDATA' => $cdata,
 	     'CHARACTERS' => $characters};
   } else {
     $self = {'END' => $SAFE_end,
@@ -345,6 +366,7 @@
 	     'STARTTAG' => $SAFE_startTag,
 	     'EMPTYTAG' => $SAFE_emptyTag,
 	     'ENDTAG' => $SAFE_endTag,
+	     'CDATA' => $SAFE_cdata,
 	     'CHARACTERS' => $SAFE_characters};
   }
 
@@ -500,6 +522,11 @@
   &{$self->{CHARACTERS}};
 }
 
+sub cdata {
+  my $self = shift;
+  &{$self->{CDATA}};
+}
+
 #
 # Query the current element.
 #
@@ -1093,7 +1120,7 @@
 
   $writer->xmlDecl("UTF-8");
 
-=item doctype($name, [$publicId, $systemId])
+=item doctype($name[, $publicId], $systemId[, $internalSubset]])
 
 Add a DOCTYPE declaration to an XML document.  The declaration must
 appear before the beginning of the root element.  If you provide a
