<?xml version='1.0'?>
<!--
   Copyright 2002, 2003, Garrett A. Wollman
   All rights reserved.
  
   Redistribution and use in source and formatted forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in formatted form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
  
   THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.
  
   $Id: make-description.xsl,v 1.5 2006/01/02 20:41:36 wollman Exp $
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version='1.0'>
  <xsl:output method='html' version='4.01' encoding='iso-8859-1' indent='yes'/>
  <xsl:param name="size"/>
  <xsl:param name="number"/>
  <xsl:param name="index"/>
  <xsl:param name="metadata"/>
  <xsl:param name="prefix"/>

  <xsl:template match="/">
    <xsl:comment>
      <xsl:text>Automatically generated: do not edit!</xsl:text>
    </xsl:comment>
    <xsl:apply-templates select="/photos/photo[@number = $number]"/>
  </xsl:template>

  <xsl:template match='title' mode='short'>
    <xsl:choose>
      <xsl:when test='count(@short-form) &gt; 0'>
	<xsl:value-of select='@short-form'/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select='text()'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match='title'>
    <xsl:value-of select='text()'/>
  </xsl:template>

  <xsl:template match='description'>
    <xsl:value-of disable-output-escaping='yes' select='text()'/>
  </xsl:template>

  <xsl:template match='photo'>
    <xsl:variable name="nextphoto" select="./following-sibling::photo[@show = 'yes' and size[$size]/@show = 'yes']"/>
    <xsl:variable name="prevphotos" select="./preceding-sibling::photo[@show = 'yes' and size[$size]/@show = 'yes']"/>
    <xsl:variable name="prevphoto" select="$prevphotos[count($prevphotos)]"/>
    <html>
      <head>
	<title>
	  <xsl:if test="string-length($prefix)">
	    <xsl:value-of select="$prefix"/>
	    <xsl:text>: </xsl:text>
	  </xsl:if>
	  <xsl:apply-templates select="title"/>
	</title>
	<link rel="meta" type="application/rdf+xml" href="{$indexmeta}"/>
      </head>
      <body>
	<h1>
	  <xsl:apply-templates select="title"/>
	</h1>

	<xsl:variable name="sizeinfo" select="id($size)"/>
	<xsl:variable name="allsizes" select="size[@show = 'yes' and id(@ref)/@show = 'yes']"/>
	<xsl:variable name="this" select="$allsizes[@ref = $size]"/>
	<xsl:if test="not($this)">
	  <xsl:message terminate='yes'>
	    <xsl:text>Specified size not found
</xsl:text>
	  </xsl:message>
	</xsl:if>
	<xsl:variable name="next" select="$this/following-sibling::size[@show = 'yes' and id(@ref)/@show = 'yes']"/>
	<xsl:variable name="orientation" select="$this/@orientation"/>

	<p align='center'><xsl:element name="a">
	  <xsl:if test="$next">
	    <xsl:attribute name="href">
	      <xsl:value-of select="concat(@number, '-', id($next/@ref)/@name, '.html')"/>
	    </xsl:attribute>
	  </xsl:if>
	  <xsl:element name="img">
	    <xsl:attribute name="src">
	      <xsl:value-of select="concat(@number, '-', $sizeinfo/@name, '.', @format)"/>
	    </xsl:attribute>
	    <xsl:attribute name="alt">
	      <xsl:apply-templates select="title" mode="short"/>
	    </xsl:attribute>
	    <xsl:choose>
	      <xsl:when test="$orientation = 'landscape'">
		<xsl:attribute name="width">
		  <xsl:value-of select="$sizeinfo/@width"/>
		</xsl:attribute>
		<xsl:attribute name="height">
		  <xsl:value-of select="$sizeinfo/@height"/>
		</xsl:attribute>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:attribute name="width">
		  <xsl:value-of select="$sizeinfo/@height"/>
		</xsl:attribute>
		<xsl:attribute name="height">
		  <xsl:value-of select="$sizeinfo/@width"/>
		</xsl:attribute>
	      </xsl:otherwise>
	    </xsl:choose>
	  </xsl:element> <!-- IMG -->
	</xsl:element></p> <!-- A -->
	<br/>
	<p align='center'>
	  <xsl:text>[</xsl:text>
	  <xsl:element name='a'>
	    <xsl:attribute name="href">
	      <xsl:value-of select='$index'/>
	    </xsl:attribute>
	    <xsl:text> Up</xsl:text>
	  </xsl:element>
	  <xsl:if test='$prevphoto'>
	    <xsl:element name='a'>
	      <xsl:attribute name='href'>
		<xsl:value-of select="concat($prevphoto/@number, '-', id($size)/@name, '.html')"/>
	      </xsl:attribute>
	      <xsl:text> | Prior</xsl:text>
	    </xsl:element>
	  </xsl:if>
	  <xsl:if test='$nextphoto'>
	    <xsl:element name='a'>
	      <xsl:attribute name='href'>
		<xsl:value-of select="concat($nextphoto/@number, '-', id($size)/@name, '.html')"/>
	      </xsl:attribute>
	      <xsl:text> | Next</xsl:text>
	    </xsl:element>
	  </xsl:if>
	  <xsl:text> ]</xsl:text>
	</p>
	<xsl:apply-templates select="description"/>
	<xsl:if test="see-also">
	  <h2>
	    <xsl:text>See also</xsl:text>
	  </h2>
	  <ul>
	    <xsl:apply-templates select="see-also"/>
	  </ul>
	</xsl:if>
	<hr/>
	<p>
	  <xsl:text>Copyright </xsl:text>
	  <xsl:value-of select="/photos/@copyright-year"/>
	  <xsl:text>, </xsl:text>
	  <xsl:value-of select="@photog"/>
	  <xsl:text>.  All rights reserved.</xsl:text>
	  <xsl:choose>
	    <xsl:when test="@date">
	      <xsl:text>  Photograph taken </xsl:text>
	      <xsl:value-of select="@date"/>
	      <xsl:text>.</xsl:text>
	    </xsl:when>
	    <xsl:when test="/photos/@date">
	      <xsl:text>  Photograph taken </xsl:text>
	      <xsl:value-of select="/photos/@date"/>
	      <xsl:text>.</xsl:text>
	    </xsl:when>
	  </xsl:choose>
        </p>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="see-also">
    <xsl:variable name="xref" select="/photos/photo[@number = current()/@number]"/>
    <xsl:if test="$xref[@show = 'yes' and size[@ref = $size and @show = 'yes']]">
      <li>
	<xsl:element name='a'>
	  <xsl:attribute name='href'>
	    <xsl:value-of select="concat($xref/@number, '-', id($size)/@name, '.html')"/>
	  </xsl:attribute>
	  <xsl:apply-templates select="$xref/title"/>
	</xsl:element>
      </li>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
