<?xml version="1.0"?>
<!--
   Copyright 2002, Garrett A. Wollman
   All rights reserved.
  
   Redistribution and use in source and formatted forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in formatted form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
  
   THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.
  
   $Id: make-Makefile.xsl,v 1.14 2006/04/30 20:18:41 wollman Exp $
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">
  <xsl:param name='processor' value='xsltproc'/>
  <xsl:param name='libdir' value='.'/>
  <xsl:param name='indexname' value='index.xml'/>
  <xsl:param name='prefix'/>
  <xsl:output method="text" encoding="ISO-8859-1"/>
  
  <xsl:template match="/">
    <xsl:text># Automatically generated -- do not edit!
PROC=		</xsl:text>
    <xsl:value-of select="$processor"/>
    <xsl:text>
LIBDIR=		</xsl:text>
    <xsl:value-of select="$libdir"/>
    <xsl:text>
INDEX=		</xsl:text>
    <xsl:value-of select="$indexname"/>
    <xsl:text>
PREFIX=		"</xsl:text>
    <xsl:value-of select='$prefix'/>
    <xsl:text>"
</xsl:text>
    <xsl:text>
CONVERT=	convert
INDEXHTML=	$(INDEX:.xml=.html)
INDEXRDF=	$(INDEX:.xml=.rdf)
PHOTOGS=	photogs-${INDEX}
</xsl:text>
    <xsl:apply-templates select="/photos/photo[@show = 'yes']"/>
    <xsl:text>

all:	Makefile $(INDEXHTML) $(INDEXRDF)

Makefile:	$(LIBDIR)/make-Makefile.xsl $(INDEX)
	${PROC} --stringparam indexname $(INDEX) \
		--stringparam libdir $(LIBDIR) \
		--stringparam processor $(PROC) \
		--stringparam prefix $(PREFIX) \
		-o $@ $(LIBDIR)/make-Makefile.xsl $(INDEX)

${INDEXHTML}:	$(LIBDIR)/index.xsl $(INDEX) ${PHOTOGS}
	$(PROC) --stringparam photogs ${PHOTOGS} \
		--stringparam indexmeta $(INDEXRDF) \
		--stringparam prefix $(PREFIX) \
		-o $@ $(LIBDIR)/index.xsl $(INDEX)

${INDEXRDF}:	$(LIBDIR)/make-metadata.xsl $(INDEX) $(PHOTOGS)
	$(PROC) --stringparam indexhtml $(INDEXHTML) \
		--stringparam photogs $(PHOTOGS) \
		-o $@ $(LIBDIR)/make-metadata.xsl $(INDEX)

${PHOTOGS}:	$(LIBDIR)/make-photog-list.xsl $(LIBDIR)/rexml.pl ${INDEX}
	${PROC} ${LIBDIR}/make-photog-list.xsl ${INDEX} \
		| perl $(LIBDIR)/rexml.pl &gt; $@

clean::
	rm -f ${INDEXHTML} ${INDEXRDF} ${PHOTOGS}

</xsl:text>
  </xsl:template>

  <xsl:template match="size">
    <xsl:value-of select="concat(../@number, '-', id(@ref)/@name, '.html')"/>
    <xsl:text> </xsl:text>
  </xsl:template>

  <xsl:template name="makeImage">
    <xsl:param name="size"/>
    <xsl:variable name="image" select="concat($size/../@number, '-', id($size/@ref)/@name, '.', $size/../@format)"/>
    <xsl:variable name="orig" select="concat($size/../@number, '-', id('orig')/@name, '.', $size/../@format)"/>
    <xsl:value-of select="$size/../@number"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$image"/>
    <xsl:text>

</xsl:text>
    <xsl:value-of select="$image"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$orig"/>
    <xsl:text>
	$(CONVERT) </xsl:text>
    <xsl:value-of select="$orig"/>
    <xsl:text> </xsl:text>
    <xsl:choose>
      <xsl:when test="../processing">
	<xsl:value-of select="../processing/text()"/>
      </xsl:when>
      <xsl:when test="@orientation = 'portrait'">
	<xsl:text>-filter lanczos -support 1.0 -rotate -90 -antialias </xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>-filter lanczos -support 1.0 -antialias </xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>-resize </xsl:text>
    <xsl:choose>
      <xsl:when test="@orientation = 'portrait'">
	<xsl:value-of select="id(@ref)/@height"/>
	<xsl:text>x</xsl:text>
	<xsl:value-of select="id(@ref)/@width"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="id(@ref)/@width"/>
	<xsl:text>x</xsl:text>
	<xsl:value-of select="id(@ref)/@height"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> -comment "Copyright </xsl:text>
    <xsl:value-of select="/photos/@copyright-year"/>
    <xsl:text>, </xsl:text>
    <xsl:value-of select="../@photog"/>
    <xsl:text>" </xsl:text>
    <xsl:value-of select="$image"/>
      <xsl:text>

clean::
	rm -f </xsl:text>
      <xsl:value-of select="$image"/>
      <xsl:text>
</xsl:text>
  </xsl:template>

  <xsl:template match="photo">
    <xsl:variable name='sizes' select="size[@ref != 'thumb' and @show = 'yes' and id(@ref)/@show = 'yes']"/>
    <xsl:text>
all:	</xsl:text>
    <xsl:value-of select="@number"/>
    <xsl:text>
</xsl:text>
    <xsl:value-of select="@number"/>
    <xsl:text>:	</xsl:text>
    <xsl:apply-templates select="$sizes"/>
    <xsl:text>
	@echo </xsl:text>
    <xsl:value-of select="@number"/>
    <xsl:text>

.PHONY: </xsl:text>
    <xsl:value-of select="@number"/>
    <xsl:text>
</xsl:text>
    <xsl:variable name="origfile" select="concat(@number, '-orig.', @format)"/>
    <xsl:for-each select="$sizes">
      <xsl:variable name="filename" select="concat(../@number, '-', id(@ref)/@name, '.html')"/>
      <xsl:text>
</xsl:text>
      <xsl:value-of select="$filename"/>
      <xsl:text>: $(LIBDIR)/make-description.xsl $(INDEX)
	@$(PROC) --stringparam number </xsl:text>
      <xsl:value-of select="../@number"/>
      <xsl:text> \
		 --stringparam size </xsl:text>
      <xsl:value-of select="@ref"/>
      <xsl:text> \
		 --stringparam index $(INDEXHTML)</xsl:text>
      <xsl:text> \
		 --stringparam indexmeta $(INDEXRDF)</xsl:text>
      <xsl:text> \
		 --stringparam prefix $(PREFIX)</xsl:text>
      <xsl:text> \
		 -o $@ $(LIBDIR)/make-description.xsl $(INDEX)

clean::
	rm -f </xsl:text>
      <xsl:value-of select="$filename"/>
      <xsl:text>

</xsl:text>
    </xsl:for-each>
    <xsl:for-each select="size[@ref != 'orig' and @show = 'yes' and id(@ref)/@show = 'yes']">
      <xsl:call-template name="makeImage">
	<xsl:with-param name="size" select="."/>
      </xsl:call-template>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
