<?xml version='1.0' encoding='us-ascii'?>
<!--
   Copyright 2002, 2003, Garrett A. Wollman
   All rights reserved.
  
   Redistribution and use in source and formatted forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in formatted form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
  
   THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.
  
   $Id: index.xsl,v 1.5 2006/01/02 20:42:32 wollman Exp $
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version='1.0'>
  <xsl:param name="photogs"/>
  <xsl:param name="prefix"/>
  <xsl:param name="indexmeta"/>
  <xsl:output method='html' version='4.01' encoding='iso-8859-1' indent='yes'/>

  <xsl:template match="/">
    <xsl:comment>
      <xsl:text>Automatically generated from index.xml by index.xsl.</xsl:text>
    </xsl:comment>
    <html>
      <head>
	<title>
	  <xsl:if test="string-length($prefix)">
	    <xsl:value-of select="$prefix"/>
	    <xsl:text>: </xsl:text>
	  </xsl:if>
	  <xsl:if test="/photos/title/@series">
	    <xsl:value-of select="/photos/title/@series"/>
	    <xsl:text>: </xsl:text>
	  </xsl:if>
	  <xsl:value-of select="/photos/title"/>
	</title>
	<link rel="meta" type="application/rdf+xml" href="{$indexmeta}"/>
      </head>
      <body>
	<h1>
	  <xsl:value-of select="/photos/title"/>
	</h1>
	<xsl:apply-templates select="/photos/description"/>
	<table align='center'>
	  <xsl:call-template name='makeTableRows'>
	    <xsl:with-param name='photos' 
		select='/photos/photo[@show = "yes"]'/>
	  </xsl:call-template>
	</table>
	<hr/>
	<p><xsl:text>Copyright </xsl:text>
	  <xsl:value-of select='/photos/@copyright-year'/>
	  <xsl:text> </xsl:text>
	  <xsl:call-template name='formatList'>
	    <xsl:with-param name='list' select='document($photogs, current())/list/item'/>
	  </xsl:call-template>
	  <xsl:text>.  All rights reserved.</xsl:text>
	</p>
      </body>
    </html>
  </xsl:template>

<!-- Format a list in English, recursively. -->
  <xsl:template name='formatList'>
    <xsl:param name='list'/>
    <xsl:param name='start' select='1'/>
    <xsl:choose>
      <xsl:when test='$start &gt; count($list)'/>
      <xsl:when test='count($list) = 1'>
	<xsl:value-of select='$list[1]'/>
      </xsl:when>
      <xsl:when test='count($list) = 2'>
	<xsl:value-of select='$list[1]'/>
	<xsl:text> and </xsl:text>
	<xsl:value-of select='$list[2]'/>
      </xsl:when>
      <xsl:when test='$start = count($list)'>
	<xsl:text>and </xsl:text>
	<xsl:value-of select='$list[$start]'/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select='$list[$start]'/>
	<xsl:text>, </xsl:text>
	<xsl:call-template name='formatList'>
	  <xsl:with-param name='list' select='$list'/>
	  <xsl:with-param name='start' select='$start + 1'/>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match='title' mode='short'>
    <xsl:choose>
      <xsl:when test='count(@short-form) &gt; 0'>
	<xsl:value-of select='@short-form'/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select='text()'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match='title'>
    <xsl:value-of select='text()'/>
  </xsl:template>

  <xsl:template match='description'>
    <xsl:value-of disable-output-escaping='yes' select='text()'/>
  </xsl:template>

  <xsl:template name='makeTableRows'>
    <xsl:param name='photos'/>
    <tr valign='top'>
      <xsl:apply-templates select='$photos[position() &lt;= 4]'/>
    </tr>
    <xsl:if test='count($photos) &gt; 4'>
      <xsl:call-template name='makeTableRows'>
	<xsl:with-param name='photos' select='$photos[position() &gt; 4]'/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match='photo'>
    <xsl:variable name="thumb" select='/photos/sizes/sizeinfo'/>
    <xsl:variable name="thumbname" select='$thumb/@name'/>
    <xsl:variable name="thumbwidth" select='$thumb/@width'/>
    <xsl:variable name="thumbheight" select='$thumb/@height'/>
    <td>
      <table align='center' border='1'>
	<tr>
	  <td align='center'>
	    <xsl:element name='a'>
	      <xsl:variable name='next' select="size[@ref != 'thumb' and @show = 'yes' and id(@ref)/@show = 'yes']"/>
	      <xsl:if test='$next'>
		<xsl:attribute name='href'>
		  <xsl:value-of select='concat(@number, "-", id($next[1]/@ref)/@name, ".html")'/>
		</xsl:attribute>
	      </xsl:if>
	      <xsl:element name='img'>
		<xsl:attribute name='src'>
		  <xsl:value-of select='concat(@number, "-", $thumbname, ".", @format)'/>
		</xsl:attribute>
		<xsl:choose>
		  <xsl:when test='count(size[@orientation = "portrait"]) &gt; 0'>
	            <xsl:attribute name='width'>
		      <xsl:value-of select='$thumbheight'/>
		    </xsl:attribute>
		    <xsl:attribute name='height'>
		      <xsl:value-of select='$thumbwidth'/>
		    </xsl:attribute>
		  </xsl:when>
		  <xsl:otherwise>
	            <xsl:attribute name='width'>
		      <xsl:value-of select='$thumbwidth'/>
		    </xsl:attribute>
		    <xsl:attribute name='height'>
		      <xsl:value-of select='$thumbheight'/>
		    </xsl:attribute>
		  </xsl:otherwise>
		</xsl:choose>
		<xsl:attribute name='alt'>
		  <xsl:apply-templates select='title' mode='short'/>
		</xsl:attribute>
	      </xsl:element> <!-- IMG -->
	    </xsl:element> <!-- A -->
	  </td>
	</tr>
	<tr>
	  <td align='center'>
	    <xsl:apply-templates select='title'/>
	  </td>
	</tr>
      </table>
    </td>
  </xsl:template>
</xsl:stylesheet>
